// Copyright ® 2025 OneSpan North America, Inc. All rights reserved. 

 
/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import SwiftUI
import UIKit

struct UIKitSampleView: UIViewControllerRepresentable {
    @Binding private var isPresented: Bool
    @Binding private var scanResult: ScanResult?
    
    init(isPresented: Binding<Bool>, scanResult: Binding<ScanResult?>) {
        self._isPresented = isPresented
        self._scanResult = scanResult
    }
    
    func makeUIViewController(context: Context) -> UIKitSampleController {
        let vc = UIKitSampleController()
        vc.delegate = context.coordinator
        return vc
    }
    
    func updateUIViewController(_ uiViewController: UIKitSampleController, context: Context) {
        // Update view controller state here if needed
    }
    
    func makeCoordinator() -> Coordinator {
        return Coordinator(isPresented: $isPresented, scanResult: $scanResult)
    }
    
    class Coordinator: NSObject, UIKitSampleControllerDelegate {
        @Binding private var isPresented: Bool
        @Binding private var scanResult: ScanResult?
        
        init(isPresented: Binding<Bool>, scanResult: Binding<ScanResult?>) {
            self._isPresented = isPresented
            self._scanResult = scanResult
        }

        func didReceiveResult(_ scanResult: ScanResult) {
            self.scanResult = scanResult
            self.isPresented = false
        }
    }
}
